/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.tangyuan;

import com.renyigesai.immortalers_delight.block.tangyuan.TangyuanBlockEntity;
import com.renyigesai.immortalers_delight.recipe.TangyuanRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.ModTags;

public class UnfinishedTangyuanBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape BOX = UnfinishedTangyuanBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);

    public UnfinishedTangyuanBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static boolean canBePlacedAt(Level level, BlockPos blockpos1, Direction horizontalDirection) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BOX;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof TangyuanBlockEntity) {
            TangyuanBlockEntity tangyuanBlockEntity = (TangyuanBlockEntity)blockEntity;
            if (tangyuanBlockEntity.residualProgress > 0) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof TangyuanBlockEntity) {
            TangyuanBlockEntity tangyuanBlockEntity = (TangyuanBlockEntity)tileEntity;
            ItemStack heldStack = player.m_21120_(hand);
            ItemStack offhandStack = player.m_21206_();
            TangyuanRecipe tangyuanRecipe = tangyuanBlockEntity.fineRecipe();
            if (tangyuanRecipe != null && tangyuanRecipe.getTool().test(heldStack)) {
                if (tangyuanBlockEntity.tryCraftItem(1, pos, state)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (tangyuanBlockEntity.tryInput(heldStack, true) || tangyuanBlockEntity.tryInput(offhandStack, true)) {
                if (!offhandStack.m_41619_()) {
                    if (hand.equals((Object)InteractionHand.MAIN_HAND) && !offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT) && !(heldStack.m_41720_() instanceof BlockItem)) {
                        return InteractionResult.PASS;
                    }
                    if (hand.equals((Object)InteractionHand.OFF_HAND) && offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT)) {
                        return InteractionResult.PASS;
                    }
                }
                if (heldStack.m_41619_()) {
                    return InteractionResult.PASS;
                }
                if (tangyuanBlockEntity.tryInput(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack, false)) {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            } else if (hand.equals((Object)InteractionHand.MAIN_HAND) && heldStack.m_41619_()) {
                ItemStack output = tangyuanBlockEntity.tryOutput();
                if (!output.m_41619_()) {
                    if (!player.m_150109_().m_36054_(output)) {
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)output);
                    }
                } else if (!player.m_7500_()) {
                    if (!player.m_150109_().m_36054_(tangyuanBlockEntity.tryRemoveInput())) {
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tangyuanBlockEntity.tryRemoveInput());
                    }
                } else {
                    tangyuanBlockEntity.tryRemoveInput();
                }
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12634_, SoundSource.BLOCKS, 0.25f, 0.5f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof TangyuanBlockEntity) {
                TangyuanBlockEntity blenderBlockEntity = (TangyuanBlockEntity)blockEntity;
                blenderBlockEntity.drops(blenderBlockEntity);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TangyuanBlockEntity(pos, state);
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ToolCarvingEvent {
        @SubscribeEvent
        public static void onSneakPlaceTool(PlayerInteractEvent.RightClickBlock event) {
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            Player player = event.getEntity();
            ItemStack heldStack = player.m_21205_();
            BlockEntity tileEntity = level.m_7702_(event.getPos());
            if (player.m_36341_() && !heldStack.m_41619_() && tileEntity instanceof TangyuanBlockEntity) {
                boolean success;
                TangyuanBlockEntity tangyuanBlockEntity = (TangyuanBlockEntity)tileEntity;
                tangyuanBlockEntity.m_6836_(4, heldStack);
                boolean bl = success = !tangyuanBlockEntity.m_8020_(4).m_41619_();
                if (success) {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
        }
    }
}

